*! version 5.0
* 13 August 2018
* NIDS
* Expenditure Data Prep

* THIS IS A FOOD AND NON-FOOD EXPENDITURE DO FILE: 3 OF 14

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Food_NonFood Expenditure - Master  Food_NonFood Expenditure do file  (1 of 14).do"

*=====================================================================================================================================
* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

version 12.0

*-------------------------------------------------------------------------------------------------------------------------------------
* This file generates all the derived variables used for analysis and imputation. 
* All variables are recoded so that all missing values are counted as the same

/*
Renaming the expenditure data back to the questionaire number allows for loops and
shortcuts when performing calculations for over 80 different expenditure items. 
*/
*================================================================================

use "$DataOUT\tempdata.dta", clear

**Renaming of food expenditure variables
rename	w1_h_fdtot	e1_1
rename	w1_h_fdmm	e1_2_1
rename	w1_h_fdsmp	e1_2_2
rename	w1_h_fdflr	e1_2_3
rename	w1_h_fdrice	e1_2_4
rename	w1_h_fdpas	e1_2_5
rename	w1_h_fdbis	e1_2_6
rename	w1_h_fdrm	e1_2_7
rename	w1_h_fdrmc	e1_2_8
rename	w1_h_fdchi	e1_2_9
rename	w1_h_fdfsh	e1_2_10
rename	w1_h_fdfshc	e1_2_11
rename	w1_h_fdvegd	e1_2_12
rename	w1_h_fdpot	e1_2_13
rename	w1_h_fdvego	e1_2_14
rename	w1_h_fdfru	e1_2_15
rename	w1_h_fdoil	e1_2_16
rename	w1_h_fdmar	e1_2_17
rename	w1_h_fdpb	e1_2_18
rename	w1_h_fdmlk	e1_2_19
rename	w1_h_fdegg	e1_2_20
rename	w1_h_fdsug	e1_2_21
rename	w1_h_fdsd	e1_2_22
rename	w1_h_fdfrut	e1_2_23
rename	w1_h_fdcer	e1_2_24
rename	w1_h_fdbaby	e1_2_25
rename	w1_h_fdslt	e1_2_26
rename	w1_h_fdsoy	e1_2_27
rename	w1_h_fdcof	e1_2_28
rename	w1_h_fdhmp	e1_2_29
rename	w1_h_fdrdy	e1_2_30
rename	w1_h_fdout	e1_2_31
rename	w1_h_fdo	e1_2_32
		
rename	w1_h_fdmmspn	e1_3_1
rename	w1_h_fdsmpspn	e1_3_2
rename	w1_h_fdflrspn	e1_3_3
rename	w1_h_fdricespn	e1_3_4
rename	w1_h_fdpasspn	e1_3_5
rename	w1_h_fdbisspn	e1_3_6
rename	w1_h_fdrmspn	e1_3_7
rename	w1_h_fdrmcspn	e1_3_8
rename	w1_h_fdchispn	e1_3_9
rename	w1_h_fdfshspn	e1_3_10
rename	w1_h_fdfshcspn	e1_3_11
rename	w1_h_fdvegdspn	e1_3_12
rename	w1_h_fdpotspn	e1_3_13
rename	w1_h_fdvegospn	e1_3_14
rename	w1_h_fdfruspn	e1_3_15
rename	w1_h_fdoilspn	e1_3_16
rename	w1_h_fdmarspn	e1_3_17
rename	w1_h_fdpbspn	e1_3_18
rename	w1_h_fdmlkspn	e1_3_19
rename	w1_h_fdeggspn	e1_3_20
rename	w1_h_fdsugspn	e1_3_21
rename	w1_h_fdsdspn	e1_3_22
rename	w1_h_fdfrutspn	e1_3_23
rename	w1_h_fdcerspn	e1_3_24
rename	w1_h_fdbabyspn	e1_3_25
rename	w1_h_fdsltspn	e1_3_26
rename	w1_h_fdsoyspn	e1_3_27
rename	w1_h_fdcofspn	e1_3_28
rename	w1_h_fdhmpspn	e1_3_29
rename	w1_h_fdrdyspn	e1_3_30
rename	w1_h_fdoutspn	e1_3_31
rename	w1_h_fdospn	e1_3_32
		
rename	w1_h_fdmmgft	e1_4_1
rename	w1_h_fdsmpgft	e1_4_2
rename	w1_h_fdflrgft	e1_4_3
rename	w1_h_fdricegft	e1_4_4
rename	w1_h_fdpasgft	e1_4_5
rename	w1_h_fdbisgft	e1_4_6
rename	w1_h_fdrmgft	e1_4_7
rename	w1_h_fdrmcgft	e1_4_8
rename	w1_h_fdchigft	e1_4_9
rename	w1_h_fdfshgft	e1_4_10
rename	w1_h_fdfshcgft	e1_4_11
rename	w1_h_fdvegdgft	e1_4_12
rename	w1_h_fdpotgft	e1_4_13
rename	w1_h_fdvegogft	e1_4_14
rename	w1_h_fdfrugft	e1_4_15
rename	w1_h_fdoilgft	e1_4_16
rename	w1_h_fdmargft	e1_4_17
rename	w1_h_fdpbgft	e1_4_18
rename	w1_h_fdmlkgft	e1_4_19
rename	w1_h_fdegggft	e1_4_20
rename	w1_h_fdsuggft	e1_4_21
rename	w1_h_fdsdgft	e1_4_22
rename	w1_h_fdfrutgft	e1_4_23
rename	w1_h_fdcergft	e1_4_24
rename	w1_h_fdbabygft	e1_4_25
rename	w1_h_fdsltgft	e1_4_26
rename	w1_h_fdsoygft	e1_4_27
rename	w1_h_fdcofgft	e1_4_28
rename	w1_h_fdhmpgft	e1_4_29
rename	w1_h_fdrdygft	e1_4_30
rename	w1_h_fdoutgft	e1_4_31
rename	w1_h_fdogft	e1_4_32
		
rename	w1_h_fdmmpay	e1_5_1
rename	w1_h_fdsmppay	e1_5_2
rename	w1_h_fdflrpay	e1_5_3
rename	w1_h_fdricepay	e1_5_4
rename	w1_h_fdpaspay	e1_5_5
rename	w1_h_fdbispay	e1_5_6
rename	w1_h_fdrmpay	e1_5_7
rename	w1_h_fdrmcpay	e1_5_8
rename	w1_h_fdchipay	e1_5_9
rename	w1_h_fdfshpay	e1_5_10
rename	w1_h_fdfshcpay	e1_5_11
rename	w1_h_fdvegdpay	e1_5_12
rename	w1_h_fdpotpay	e1_5_13
rename	w1_h_fdvegopay	e1_5_14
rename	w1_h_fdfrupay	e1_5_15
rename	w1_h_fdoilpay	e1_5_16
rename	w1_h_fdmarpay	e1_5_17
rename	w1_h_fdpbpay	e1_5_18
rename	w1_h_fdmlkpay	e1_5_19
rename	w1_h_fdeggpay	e1_5_20
rename	w1_h_fdsugpay	e1_5_21
rename	w1_h_fdsdpay	e1_5_22
rename	w1_h_fdfrutpay	e1_5_23
rename	w1_h_fdcerpay	e1_5_24
rename	w1_h_fdbabypay	e1_5_25
rename	w1_h_fdsltpay	e1_5_26
rename	w1_h_fdsoypay	e1_5_27
rename	w1_h_fdcofpay	e1_5_28
rename	w1_h_fdhmppay	e1_5_29
rename	w1_h_fdrdypay	e1_5_30
rename	w1_h_fdoutpay	e1_5_31
rename	w1_h_fdopay	e1_5_32
		
rename	w1_h_fdmmprd	e1_6_1
rename	w1_h_fdsmpprd	e1_6_2
rename	w1_h_fdflrprd	e1_6_3
rename	w1_h_fdriceprd	e1_6_4
rename	w1_h_fdpasprd	e1_6_5
rename	w1_h_fdbisprd	e1_6_6
rename	w1_h_fdrmprd	e1_6_7
rename	w1_h_fdrmcprd	e1_6_8
rename	w1_h_fdchiprd	e1_6_9
rename	w1_h_fdfshprd	e1_6_10
rename	w1_h_fdfshcprd	e1_6_11
rename	w1_h_fdvegdprd	e1_6_12
rename	w1_h_fdpotprd	e1_6_13
rename	w1_h_fdvegoprd	e1_6_14
rename	w1_h_fdfruprd	e1_6_15
rename	w1_h_fdoilprd	e1_6_16
rename	w1_h_fdmarprd	e1_6_17
rename	w1_h_fdpbprd	e1_6_18
rename	w1_h_fdmlkprd	e1_6_19
rename	w1_h_fdeggprd	e1_6_20
rename	w1_h_fdsugprd	e1_6_21
rename	w1_h_fdsdprd	e1_6_22
rename	w1_h_fdfrutprd	e1_6_23
rename	w1_h_fdcerprd	e1_6_24
rename	w1_h_fdbabyprd	e1_6_25
rename	w1_h_fdsltprd	e1_6_26
rename	w1_h_fdsoyprd	e1_6_27
rename	w1_h_fdcofprd	e1_6_28
rename	w1_h_fdhmpprd	e1_6_29
rename	w1_h_fdrdyprd	e1_6_30
rename	w1_h_fdoutprd	e1_6_31
rename	w1_h_fdoprd	e1_6_32

*===============================================================================

*Renaming of non-food expenditure variables		
rename	w1_h_nfcig	e2_1_1
rename	w1_h_nfalc	e2_1_2
rename	w1_h_nfent	e2_1_3
rename	w1_h_nfspr	e2_1_4
rename	w1_h_nfper	e2_1_5
rename	w1_h_nfjew	e2_1_6
rename	w1_h_nfpap	e2_1_7
rename	w1_h_nfcel	e2_1_8
rename	w1_h_nftel	e2_1_9
rename	w1_h_nflot	e2_1_10
rename	w1_h_nfnet	e2_1_11
rename	w1_h_nftrp	e2_1_12
rename	w1_h_nfcer	e2_1_13
rename	w1_h_nfcar	e2_1_14
rename	w1_h_nfpetr	e2_1_15
rename	w1_h_nftran	e2_1_16
rename	w1_h_nfwat	e2_1_17
rename	w1_h_nfele	e2_1_18
rename	w1_h_nfene	e2_1_19
rename	w1_h_nfmun	e2_1_20
rename	w1_h_nflev	e2_1_21
rename	w1_h_nfinsl	e2_1_22
rename	w1_h_nfinsf	e2_1_23
rename	w1_h_nfinsedu	e2_1_24
rename	w1_h_nfinssh	e2_1_25
rename	w1_h_nfkit	e2_1_26
rename	w1_h_nfdwl	e2_1_27
rename	w1_h_nfbed	e2_1_28
rename	w1_h_nfmat	e2_1_29
rename	w1_h_nfhp	e2_1_30
rename	w1_h_nffrn	e2_1_31
rename	w1_h_nfclth	e2_1_32
rename	w1_h_nfcltha	e2_1_33
rename	w1_h_nfclthm	e2_1_34
rename	w1_h_nfmedaid	e2_1_35
rename	w1_h_nfdoc	e2_1_36
rename	w1_h_nfhsp	e2_1_37
rename	w1_h_nfmed	e2_1_38
rename	w1_h_nftrad	e2_1_39
rename	w1_h_nfhom	e2_1_40
rename	w1_h_nfschfee	e2_1_41
rename	w1_h_nfschstat	e2_1_42
rename	w1_h_nfschuni	e2_1_43
rename	w1_h_nfscho	e2_1_44
rename	w1_h_nfwsh	e2_1_45
rename	w1_h_nfchld	e2_1_46
rename	w1_h_nfrel	e2_1_47
rename	w1_h_nfdom	e2_1_48
rename	w1_h_nfswim	e2_1_49
rename	w1_h_nfpets	e2_1_50
rename	w1_h_nftoys	e2_1_51
rename	w1_h_nfgfts	e2_1_52
rename	w1_h_nfinctax	e2_1_53
		
rename	w1_h_nfcigspn	e2_2_1
rename	w1_h_nfalcspn	e2_2_2
rename	w1_h_nfentspn	e2_2_3
rename	w1_h_nfsprspn	e2_2_4
rename	w1_h_nfperspn	e2_2_5
rename	w1_h_nfjewspn	e2_2_6
rename	w1_h_nfpapspn	e2_2_7
rename	w1_h_nfcelspn	e2_2_8
rename	w1_h_nftelspn	e2_2_9
rename	w1_h_nflotspn	e2_2_10
rename	w1_h_nfnetspn	e2_2_11
rename	w1_h_nftrpspn	e2_2_12
rename	w1_h_nfcerspn	e2_2_13
rename	w1_h_nfcarspn	e2_2_14
rename	w1_h_nfpetrspn	e2_2_15
rename	w1_h_nftranspn	e2_2_16
rename	w1_h_nfwatspn	e2_2_17
rename	w1_h_nfelespn	e2_2_18
rename	w1_h_nfenespn	e2_2_19
rename	w1_h_nfmunspn	e2_2_20
rename	w1_h_nflevspn	e2_2_21
rename	w1_h_nfinslspn	e2_2_22
rename	w1_h_nfinsfspn	e2_2_23
rename	w1_h_nfinseduspn	e2_2_24
rename	w1_h_nfinsshspn	e2_2_25
rename	w1_h_nfkitspn	e2_2_26
rename	w1_h_nfdwlspn	e2_2_27
rename	w1_h_nfbedspn	e2_2_28
rename	w1_h_nfmatspn	e2_2_29
rename	w1_h_nfhpspn	e2_2_30
rename	w1_h_nffrnspn	e2_2_31
rename	w1_h_nfclthspn	e2_2_32
rename	w1_h_nfclthaspn	e2_2_33
rename	w1_h_nfclthmspn	e2_2_34
rename	w1_h_nfmedaidspn	e2_2_35
rename	w1_h_nfdocspn	e2_2_36
rename	w1_h_nfhspspn	e2_2_37
rename	w1_h_nfmedspn	e2_2_38
rename	w1_h_nftradspn	e2_2_39
rename	w1_h_nfhomspn	e2_2_40
rename	w1_h_nfschfeespn	e2_2_41
rename	w1_h_nfschstatspn	e2_2_42
rename	w1_h_nfschunispn	e2_2_43
rename	w1_h_nfschospn	e2_2_44
rename	w1_h_nfwshspn	e2_2_45
rename	w1_h_nfchldspn	e2_2_46
rename	w1_h_nfrelspn	e2_2_47
rename	w1_h_nfdomspn	e2_2_48
rename	w1_h_nfswimspn	e2_2_49
rename	w1_h_nfpetsspn	e2_2_50
rename	w1_h_nftoysspn	e2_2_51
rename	w1_h_nfgftsspn	e2_2_52
rename	w1_h_nfinctaxspn	e2_2_53

*********************************************************************************************************************************
*Renaming of household descriptor variables
rename w1_hhsizer hhsizer 
rename w1_hhincome hhincome 
rename w1_prov2011 province
rename w1_geo2011 geo 

*-----------------------------------------------------------------------------------------------------------------------------
gen a3 = w1_hhid
gen hhincome_pc=hhincome/hhsizer			//generating per capita income at the household level

**********************************************************************
***			Preparations
**********************************************************************

*Generates dummy variables for the type of dwelling
tab w1_h_dwltyp ,gen(dwell)
rename dwell2 house
rename dwell10 shack
rename dwell3 trad

*Generates dummy variables for the type of roof used for the dwelling
tab  w1_h_dwlmatroof,gen(roof)
rename roof5 corru
rename roof11 tile
rename roof12 asb

*Generates dummy variables for the type of wall used for the dwelling
tab  w1_h_dwlmatrwll,gen(wall)
rename wall3 brick
gen mud=wall9==1|wall12==1

*Recodes all the expenditure variables. Ensures that yes/no questions take on values of 0 or 1, and that all types of missing numeric values are recorded as system missing
quietly recode e2_1_*(3/99=.)(2=0)
quietly recode e1_4_* e1_5_* e1_6_* e1_3_* (-999/-1=.)
quietly recode e1_1 (-999/-1=.)
quietly recode e1_2_*(3/99=.)(2=0)
quietly recode e2_2_*(-999/-1=.)

*recodes dwelling descriptor variables
quietly recode w1_h_dwltyp(-999/-1=.)
quietly recode w1_h_dwlmatroof (-999/-1=.)
quietly recode w1_h_dwlmatrwll (-999/-1=.)
quietly recode  w1_h_dwlrms(-999/-1=.)

quietly recode  w1_h_ownd (-999/-1=.)
quietly recode  w1_h_empl (-999/-1=.)
quietly recode  w1_h_expnd (-999/-1=.)	
quietly recode  w1_h_tinc (-999/-1=.)	
quietly recode  w1_h_mrkv (-999/-1=.)	

*Generates log variables for use in regression analysis
gen lgd38 =log(w1_h_tinc)
gen lgd13 =log(w1_h_mrkv)
gen lgincome_pc=log(hhincome_pc)
gen lgincome=log(hhincome)
gen lgd31=log(w1_h_expnd)
gen lge1_1 =log(e1_1)

*Dummy variables for the status of the household
gen employ=w1_h_empl==1
gen grants=w1_h_grn==1
gen fridge= w1_h_ownfrg==1
gen anychildren=hhchildren>0
gen cell=w1_h_owncel==1
gen computer=w1_h_owncom==1

gen maxagesq=maxage^2
gen pensionage =maxage>65
gen adultage=maxage>25	

gen adults=hhsizer-hhchildren							//Creates a variable indicating number of adults in a household
gen equivadult = (adults+0.6*hhchildren)^0.8 

xtile pertile = hhincome_pc, n(10)						//Creates income deciles
xtile valpertile =w1_h_mrkv,n(10)

*********************Differences from the PSU medians
egen psumedage =median(maxage),by(w1_cluster)
egen psumededu =median(maxage), by(w1_cluster)
egen psumedsize =median(hhsizer), by(w1_cluster)
egen psumedinc =median(lgincome), by(w1_cluster)
egen psumedinc2=median(hhincome), by(w1_cluster)
egen psumedd2 =median(w1_h_dwlrms),by(w1_cluster)

gen psuagediff=psumedage -maxage
gen psuedudiff=psumededu -maxed
gen psusizediff=psumedsize -hhsizer
gen psuincdiff=psumedinc -lgincome
gen psud2diff=psumedd2-w1_h_dwlrms

gen psuincdiff2=psumedinc2-hhincome
gen diffsign=psuincdiff2>0
gen psuincdiff3=log(abs(psuincdiff2))
replace psuincdiff3=-psuincdiff3 if diffsign==0

*---------------------------------------------------------------------------------------------------------
save "$DataOUT\tempdata2.dta", replace
